/*   EXTRAITS DE LA LICENCE
	Copyright CEA, contributeurs : Damien
	CALISTE, laboratoire L_Sim, (2017)
  
	Adresse mèl :
	CALISTE, damien P caliste AT cea P fr.

	Ce logiciel est un programme informatique servant à visualiser des
	structures atomiques dans un rendu pseudo-3D. 

	Ce logiciel est régi par la licence CeCILL soumise au droit français et
	respectant les principes de diffusion des logiciels libres. Vous pouvez
	utiliser, modifier et/ou redistribuer ce programme sous les conditions
	de la licence CeCILL telle que diffusée par le CEA, le CNRS et l'INRIA 
	sur le site "http://www.cecill.info".

	Le fait que vous puissiez accéder à cet en-tête signifie que vous avez 
	pris connaissance de la licence CeCILL, et que vous en avez accepté les
	termes (cf. le fichier Documentation/licence.fr.txt fourni avec ce logiciel).
*/

/*   LICENCE SUM UP
	Copyright CEA, contributors : Damien
	CALISTE, laboratoire L_Sim, (2017)

	E-mail address:
	CALISTE, damien P caliste AT cea P fr.

	This software is a computer program whose purpose is to visualize atomic
	configurations in 3D.

	This software is governed by the CeCILL  license under French law and
	abiding by the rules of distribution of free software.  You can  use, 
	modify and/ or redistribute the software under the terms of the CeCILL
	license as circulated by CEA, CNRS and INRIA at the following URL
	"http://www.cecill.info". 

	The fact that you are presently reading this means that you have had
	knowledge of the CeCILL license and that you accept its terms. You can
	find a copy of this licence shipped with this software at Documentation/licence.en.txt.
*/
#ifndef VISU_UI_COMBO_VALUES_H
#define VISU_UI_COMBO_VALUES_H

#include <glib.h>
#include <glib-object.h>

#include <gtk/gtk.h>

#include <visu_data.h>
#include <extraFunctions/nodeProp.h>

/***************/
/* Public part */
/***************/

/**
 * VISU_TYPE_UI_COMBO_VALUES:
 *
 * return the type of #VisuUiComboValues.
 */
#define VISU_TYPE_UI_COMBO_VALUES	     (visu_ui_combo_values_get_type ())
/**
 * VISU_UI_COMBO_VALUES:
 * @obj: a #GObject to cast.
 *
 * Cast the given @obj into #VisuUiComboValues type.
 */
#define VISU_UI_COMBO_VALUES(obj)	        (G_TYPE_CHECK_INSTANCE_CAST(obj, VISU_TYPE_UI_COMBO_VALUES, VisuUiComboValues))
/**
 * VISU_UI_COMBO_VALUES_CLASS:
 * @klass: a #GObjectClass to cast.
 *
 * Cast the given @klass into #VisuUiComboValuesClass.
 */
#define VISU_UI_COMBO_VALUES_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST(klass, VISU_TYPE_UI_COMBO_VALUES, VisuUiComboValuesClass))
/**
 * VISU_IS_UI_COMBO_VALUES:
 * @obj: a #GObject to test.
 *
 * Test if the given @ogj is of the type of #VisuUiComboValues object.
 */
#define VISU_IS_UI_COMBO_VALUES(obj)    (G_TYPE_CHECK_INSTANCE_TYPE(obj, VISU_TYPE_UI_COMBO_VALUES))
/**
 * VISU_IS_UI_COMBO_VALUES_CLASS:
 * @klass: a #GObjectClass to test.
 *
 * Test if the given @klass is of the type of #VisuUiComboValuesClass class.
 */
#define VISU_IS_UI_COMBO_VALUES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE(klass, VISU_TYPE_UI_COMBO_VALUES))
/**
 * VISU_UI_COMBO_VALUES_GET_CLASS:
 * @obj: a #GObject to get the class of.
 *
 * It returns the class of the given @obj.
 */
#define VISU_UI_COMBO_VALUES_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS(obj, VISU_TYPE_UI_COMBO_VALUES, VisuUiComboValuesClass))


/**
 * VisuUiComboValuesPrivate:
 * 
 * Private data for #VisuUiComboValues objects.
 */
typedef struct _VisuUiComboValuesPrivate VisuUiComboValuesPrivate;

/**
 * VisuUiComboValues:
 * 
 * Common name to refer to a #_VisuUiComboValues.
 */
typedef struct _VisuUiComboValues VisuUiComboValues;
struct _VisuUiComboValues
{
  GtkComboBox parent;

  VisuUiComboValuesPrivate *priv;
};

/**
 * VisuUiComboValuesClass:
 * @parent: private.
 * 
 * Common name to refer to a #_VisuUiComboValuesClass.
 */
typedef struct _VisuUiComboValuesClass VisuUiComboValuesClass;
struct _VisuUiComboValuesClass
{
  GtkComboBoxClass parent;
};

/**
 * visu_ui_combo_values_get_type:
 *
 * This method returns the type of #VisuUiComboValues, use
 * VISU_TYPE_UI_COMBO_VALUES instead.
 *
 * Since: 3.8
 *
 * Returns: the type of #VisuUiComboValues.
 */
GType visu_ui_combo_values_get_type(void);

GtkWidget* visu_ui_combo_values_new();

gboolean visu_ui_combo_values_setNodeModel(VisuUiComboValues *combo, VisuData *data);

VisuNodeValues* visu_ui_combo_values_getActive(VisuUiComboValues *combo);
gboolean visu_ui_combo_values_setActive(VisuUiComboValues *combo,
                                        const VisuNodeValues *values);
gboolean visu_ui_combo_values_setActiveByLabel(VisuUiComboValues *combo,
                                               const gchar* label);

#endif
