/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.office;

import writer2latex.office.TableReader;
import writer2latex.office.TableView;

public class TableRange {
    private TableReader reader;
    private int nFirstRow;
    private int nLastRow;
    private int nFirstCol;
    private int nLastCol;
    private boolean bIncludeHidden;
    private boolean bIncludeFiltered;

    public TableRange(TableReader reader) {
        this.reader = reader;
        this.nFirstRow = 0;
        this.nLastRow = reader.getRowCount() - 1;
        this.nFirstCol = 0;
        this.nLastCol = reader.getColCount() - 1;
        this.bIncludeHidden = true;
        this.bIncludeFiltered = true;
    }

    public void setFirstRow(int nRow) {
        this.nFirstRow = nRow < 0 ? 0 : (nRow > this.nLastRow ? this.nLastRow : nRow);
    }

    public int getFirstRow() {
        return this.nFirstRow;
    }

    public void setLastRow(int nRow) {
        this.nLastRow = nRow < this.nFirstRow ? this.nFirstRow : (nRow >= this.reader.getRowCount() ? this.reader.getRowCount() - 1 : nRow);
    }

    public int getLastRow() {
        return this.nLastRow;
    }

    public void setFirstCol(int nCol) {
        this.nFirstCol = nCol < 0 ? 0 : (nCol > this.nLastCol ? this.nLastCol : nCol);
    }

    public int getFirstCol() {
        return this.nFirstCol;
    }

    public void setLastCol(int nCol) {
        this.nLastCol = nCol < this.nFirstCol ? this.nFirstCol : (nCol >= this.reader.getColCount() ? this.reader.getColCount() - 1 : nCol);
    }

    public int getLastCol() {
        return this.nLastCol;
    }

    public void setIncludeHidden(boolean b) {
        this.bIncludeHidden = b;
    }

    public boolean includeHidden() {
        return this.bIncludeHidden;
    }

    public void setIncludeFiltered(boolean b) {
        this.bIncludeFiltered = b;
    }

    public boolean includeFiltered() {
        return this.bIncludeFiltered;
    }

    public TableView createTableView() {
        return new TableView(this.reader, this);
    }
}

